require( "scripts/controls/colors.lua" );

standardFont = "fonts/arial.mvec";
gameFont = "fonts/vagrounded.mvec";
comicsFont = "fonts/domcasualstd.mvec";

FontArial = "fonts/arial.mvec";
FontGame = "fonts/vagrounded.mvec";
FontComics = "fonts/domcasualstd.mvec";
FontButtons = "fonts/ziptydostd.mvec";
FontHelp = "fonts/domcasualstd.mvec";

Text_Default_Style = {
    flags = kVAlignCenter + kHAlignCenter,
    x=kCenter,
    y=kCenter,
    w=kMax,
    h=kMax
};

function CreateTextStyle(font_name, size, color)
    CurrentTextStyle = {
        parent = Text_Default_Style,
        font = { font_name, size, color },
    };
    return CurrentTextStyle;
end;

function CreateText(x, y, label, x_off, y_off)
    return Group({
        Text{ x=x+x_off, y=y+y_off , label=label },
    });
end;

function CreateTextLeftAlign(x, y, label, x_off, y_off)
    return Group({
        Text{ x=x+x_off, y=y+y_off , label=label, flags = kVAlignCenter + kHAlignLeft, },
    });
end;